<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;
use Carbon\Carbon;

class AppointmentSeeder extends Seeder
{
    public function run()
    {
        $faker = Faker::create('en_US'); // Force English
        $customers = DB::table('customers')->select('id')->get();

        $startDate = Carbon::create(2025, 1, 1);
        $statusOptions = ['scheduled', 'completed', 'cancelled'];
        $locations = [
            'Main Office - Addis Ababa',
            'Branch - Bahir Dar',
            'Branch - Hawassa',
            'Online (Zoom)',
            'Phone Call'
        ];
        $subjects = [
            'Policy Review Meeting',
            'Claim Assistance Appointment',
            'Insurance Renewal Discussion',
            'Coverage Update Session',
            'New Policy Consultation'
        ];

        $descriptions = [
            'Discuss the customer’s life insurance needs.',
            'Assist the client in submitting a claim request.',
            'Review upcoming policy expiration details.',
            'Explain premium calculation and payment schedules.',
            'Provide options for new health insurance packages.',
            'Follow up on previously submitted insurance claims.',
            'Review current motor insurance coverage.',
            'Collect required documents for underwriting.',
            'Evaluate client’s eligibility for policy upgrade.',
            'Schedule a physical assessment for medical coverage.',
            'Provide support for recent incident claim submission.',
            'Consult about accident insurance packages.',
            'Discuss options for family coverage extensions.',
            'Answer questions about coverage exclusions.',
            'Help client understand deductible responsibilities.',
            'Demonstrate the insurance portal usage.',
            'Handle inquiries about delayed claim settlements.',
            'Educate client about policy renewal timelines.',
            'Offer group insurance solutions to corporate client.',
            'Verify customer identity and documentation.',
            'Discuss vehicle insurance renewal process.',
            'Explain tax benefits of certain insurance plans.',
            'Resolve issues related to policy cancellation.',
            'Provide printed copies of client’s insurance records.',
            'Meet to discuss investment-linked insurance plans.',
            'Assist in setting up auto-renew for policies.',
            'Talk through payment method changes.',
            'Update customer contact and address info.',
            'Explain travel insurance benefits and coverage.',
            'Deliver claim cheque and finalize paperwork.',
            'Answer questions about coverage limits.',
            'Prepare client for health exam requirement.',
            'Handle follow-up for a denied insurance claim.',
            'Consult for life policy beneficiary update.',
            'Assess risk factors for a new corporate policy.',
            'Schedule meeting to finalize underwriting decisions.',
            'Introduce short-term insurance options.',
            'Help client select the right premium frequency.',
            'Send missing claim files and documents.',
            'Support setup of mobile-based notifications.',
            'Review summary of insurance claim history.',
            'Revisit past claim disputes and resolutions.',
            'Generate duplicate policy certificates.',
            'Assist elderly client with digital tools.',
            'Walk through terms of multi-year policy plans.',
            'Explain inflation adjustment on premium.',
            'Coordinate with hospital for health policy update.',
            'Address missed policy renewal and penalties.',
            'Discuss customer complaints and resolutions.',
            'Conduct onboarding for new policyholder.',
            'Update contact preference and consent records.'
        ];

        $dayOffset = 0;

        foreach ($customers as $customer) {
            $day = (clone $startDate)->addDays($dayOffset);
            $startHour = rand(9, 15); // 9 AM to 3 PM
            $startTime = $day->copy()->setTime($startHour, 0);
            $endTime = $startTime->copy()->addHour();

            DB::table('appointments')->insert([
                'subject' => $faker->randomElement($subjects),
                'description' => $faker->randomElement($descriptions),
                'start_time' => $startTime,
                'end_time' => $endTime,
                'location' => $faker->randomElement($locations),
                'status' => $faker->randomElement($statusOptions),
                'customer_id' => $customer->id,
                'corporate_customer_id' => null,
                'created_by' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            $dayOffset++;
        }
    }
}
